'*************************************************************
' 
' ADOBE SYSTEMS INCORPORATED 
' Copyright 2008-2010 Adobe Systems Incorporated 
' All Rights Reserved 

' NOTICE:  Adobe permits you to use, modify, and 
' distribute this file in accordance with the terms
' of the Adobe license agreement accompanying it.  
' If you have received this file from a source 
' other than Adobe, then your use, modification,
' or distribution of it requires the prior 
' written permission of Adobe. 
' 
'*************************************************************

' CreateArtboards.vbs

' DESCRIPTION

' Creates a new document containing 6 artboards, then adds art spread
' across the artboards.
'*************************************************************

Set appRef = CreateObject("Illustrator.Application")

' Create new document with 6 artboards
Set docRef = appRef.Documents.Add(2, 612.0, 792.0, 6, 1, 20.0, 3)

' Create rectangle
Set artboardRef = docRef.Artboards(1)
rect = artboardRef.ArtboardRect
Set rectPath = docRef.PathItems.Rectangle(rect(1) - 20, rect(0) + 20, 1200, 2350, false)
Set rectColor = CreateObject("Illustrator.CMYKColor")
rectColor.Cyan = 0
rectColor.Magenta = 0
rectColor.Yellow = 20
rectColor.Black = 0
rectPath.fillColor = rectColor

' Create first star
Set star1 = docRef.PathItems.Star(620, 1610, 200, 100, 7, false)
Set starColor = CreateObject("Illustrator.CMYKColor")
starColor.Cyan = 50
starColor.Magenta = 50
starColor.Yellow = 0
starColor.Black = 0
star1.fillColor = starColor

' Create second star
Set star2 = docRef.PathItems.Star(620, 795, 200, 100, 7, false)
starColor.Cyan = 0
starColor.Yellow = 50
star2.fillColor = starColor

' Create 50 random stars
for i = 1 To 50 
	Randomize ' Initialize random number generator
	centerX = (Rnd * 1200) + 40
	centerY = (Rnd * 2300) + 40
	Set randomStar = docRef.PathItems.Star(centerX, centerY, 50, 20, 9, false)

	' Create a random CMYK color and assign as the fill color
	starColor.Cyan = Rnd * 100
	starColor.Magenta = Rnd * 100
	starColor.Yellow = Rnd * 100
	randomStar.fillColor = starColor
Next
'' SIG '' Begin signature block
'' SIG '' MIIY1QYJKoZIhvcNAQcCoIIYxjCCGMICAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFIak0RCrVKju
'' SIG '' BxxlgOjThK1lAnJPoIITuzCCA+4wggNXoAMCAQICEH6T
'' SIG '' 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
'' SIG '' CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
'' SIG '' cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
'' SIG '' EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
'' SIG '' Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
'' SIG '' aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
'' SIG '' NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
'' SIG '' bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
'' SIG '' bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
'' SIG '' RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
'' SIG '' AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
'' SIG '' FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
'' SIG '' a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
'' SIG '' AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
'' SIG '' +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
'' SIG '' 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
'' SIG '' 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
'' SIG '' RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
'' SIG '' gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
'' SIG '' gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
'' SIG '' aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
'' SIG '' CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
'' SIG '' Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
'' SIG '' bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
'' SIG '' VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
'' SIG '' VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
'' SIG '' BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
'' SIG '' nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
'' SIG '' sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
'' SIG '' JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
'' SIG '' g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
'' SIG '' UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
'' SIG '' MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
'' SIG '' BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
'' SIG '' dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
'' SIG '' MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
'' SIG '' VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
'' SIG '' AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
'' SIG '' cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
'' SIG '' sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
'' SIG '' duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
'' SIG '' TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
'' SIG '' YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
'' SIG '' vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
'' SIG '' nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
'' SIG '' 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
'' SIG '' EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
'' SIG '' FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
'' SIG '' AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
'' SIG '' MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
'' SIG '' bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
'' SIG '' MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
'' SIG '' ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
'' SIG '' MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
'' SIG '' VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
'' SIG '' IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
'' SIG '' SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
'' SIG '' st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
'' SIG '' JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
'' SIG '' dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
'' SIG '' bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
'' SIG '' K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
'' SIG '' SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
'' SIG '' ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
'' SIG '' w7wc2AR1MIIFVjCCBD6gAwIBAgIQGRoyy3Wcl7jPrBGN
'' SIG '' 1RJ/STANBgkqhkiG9w0BAQsFADCByjELMAkGA1UEBhMC
'' SIG '' VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
'' SIG '' VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYD
'' SIG '' VQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAtIEZv
'' SIG '' ciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW
'' SIG '' ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENl
'' SIG '' cnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcNMTQw
'' SIG '' MzA0MDAwMDAwWhcNMjQwMzAzMjM1OTU5WjCBkTELMAkG
'' SIG '' A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
'' SIG '' cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
'' SIG '' ZXR3b3JrMUIwQAYDVQQDEzlTeW1hbnRlYyBDbGFzcyAz
'' SIG '' IEV4dGVuZGVkIFZhbGlkYXRpb24gQ29kZSBTaWduaW5n
'' SIG '' IENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
'' SIG '' ggEKAoIBAQDQGALu7aKNCFhjDybX3SJ7iPbkx+w7Jhh4
'' SIG '' 08ekIFONg3ylP36lyCtH3w31ptnDHSWTYM983OoDLL54
'' SIG '' f1xIbacC2Un4oevrmmF8n8Am1twV2LgQfCC6XvQo9qjq
'' SIG '' p1x8xpyQkDQ8tiKs/roMOh7WXoS2W/CjgXB4io1GUnv8
'' SIG '' 20nzKRMRdE+NFrPC46AtxwMEnczDcuEODPsCjvEmF3tu
'' SIG '' rvi3M4umYUtF3/IlRMf3sJgjNtwoeQrom3KIqNjornt/
'' SIG '' CmRFpfBXkpp3BkUe65/oZvN6fZKBXwAtHrj2VhNaYg23
'' SIG '' R6GPcu+DXoLglJjhrKWthjfgp9O6sT5660Wo8cFEfeID
'' SIG '' AgMBAAGjggFtMIIBaTASBgNVHRMBAf8ECDAGAQH/AgEA
'' SIG '' MC8GA1UdHwQoMCYwJKAioCCGHmh0dHA6Ly9zLnN5bWNi
'' SIG '' LmNvbS9wY2EzLWc1LmNybDAWBgNVHSUBAf8EDDAKBggr
'' SIG '' BgEFBQcDAzAOBgNVHQ8BAf8EBAMCAQYwLgYIKwYBBQUH
'' SIG '' AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
'' SIG '' ZC5jb20wXwYDVR0gBFgwVjBUBgRVHSAAMEwwIwYIKwYB
'' SIG '' BQUHAgEWF2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUG
'' SIG '' CCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20v
'' SIG '' cnBhMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFTeW1h
'' SIG '' bnRlY1BLSS0xLTYyOTAdBgNVHQ4EFgQUFmbeSjTjUKcR
'' SIG '' hgOxbKnGrM1ZbpswHwYDVR0jBBgwFoAUf9Nlp8Ld7Lvw
'' SIG '' MAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQADggEBAD9b
'' SIG '' GfP6E9V1OCpa7p9aoEypHcXMlO7eFf71EG6kG6Vkg1QY
'' SIG '' WMQLKKGFw0505f+JfP7V7Ty6cZ9WAiaPFiqI/rCjJyLO
'' SIG '' S+I4jgCmOoZfneU+qN5kSUF0QSH9B8iEF9odZTCCyyZP
'' SIG '' OdYEJ6SBsUtJwyOLfgIyGCe3qwvzGHK2pO5nBm84pliN
'' SIG '' 4PF+XaRgxqjlUF/g6Lrij5lYtrWgqHbxovEciEFyflKX
'' SIG '' mwo2mY1Q9wHrPOfwImrlNYxjNooasdlnZl+XGu+oIJ3w
'' SIG '' L7psztmUhQDxWPF9yXwitQddAsbmC7+rk5P/JxiOMzZ+
'' SIG '' VzTxw68EwYTxVrPoh4M2+NMKMdxuLG0wggXEMIIErKAD
'' SIG '' AgECAhAeObM6nEaakCI61S77g784MA0GCSqGSIb3DQEB
'' SIG '' CwUAMIGRMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3lt
'' SIG '' YW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFu
'' SIG '' dGVjIFRydXN0IE5ldHdvcmsxQjBABgNVBAMTOVN5bWFu
'' SIG '' dGVjIENsYXNzIDMgRXh0ZW5kZWQgVmFsaWRhdGlvbiBD
'' SIG '' b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNTExMDYwMDAw
'' SIG '' MDBaFw0xNzEwMjgyMzU5NTlaMIIBDjETMBEGCysGAQQB
'' SIG '' gjc8AgEDEwJVUzEZMBcGCysGAQQBgjc8AgECFAhEZWxh
'' SIG '' d2FyZTEdMBsGA1UEDxMUUHJpdmF0ZSBPcmdhbml6YXRp
'' SIG '' b24xEDAOBgNVBAUTBzI3NDgxMjkxCzAJBgNVBAYTAlVT
'' SIG '' MRMwEQYDVQQIDApDYWxpZm9ybmlhMREwDwYDVQQHDAhT
'' SIG '' YW4gSm9zZTEjMCEGA1UECgwaQWRvYmUgU3lzdGVtcyBJ
'' SIG '' bmNvcnBvcmF0ZWQxLDAqBgNVBAsMI0lsbHVzdHJhdG9y
'' SIG '' LCBJbkRlc2lnbiwgSW5Db3B5LCBNdXNlMSMwIQYDVQQD
'' SIG '' FBpBZG9iZSBTeXN0ZW1zIEluY29ycG9yYXRlZDCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJpOMyAj
'' SIG '' 8r+7FuNs3MXed0OMajoJnoF4v8cV+9drUVII+pzb6yeV
'' SIG '' GdBTt8U03rk1a2V51gcTHAorQxs2plJIgafn/pqMzG7f
'' SIG '' 9FZui7WiMOuyif/0joytDGujeQd7xQ/23YYtZpQQ/ahz
'' SIG '' VI4Pzv44FVDGwHYfGxGaQ127Bqp5EhLX7zwFiGEPnP3V
'' SIG '' R4ZyQn2WQeA0a68KuhD6anNHize0XjSBFelrNhN4uYpk
'' SIG '' prXyGv8vKdq9a911iY/efPsRueUPYucYJCF/lBt3DaR4
'' SIG '' J/FeaSJeijyllNwAqu7XY7Jl9zB0duRLlRFpGJeCymhY
'' SIG '' 3wvU6039CHBnrYIXZ/ldAWUpz+MCAwEAAaOCAZYwggGS
'' SIG '' MC4GA1UdEQQnMCWgIwYIKwYBBQUHCAOgFzAVDBNVUy1E
'' SIG '' RUxBV0FSRS0yNzQ4MTI5MAkGA1UdEwQCMAAwKwYDVR0f
'' SIG '' BCQwIjAgoB6gHIYaaHR0cDovL3N3LnN5bWNiLmNvbS9z
'' SIG '' dy5jcmwwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwMwDgYD
'' SIG '' VR0PAQH/BAQDAgeAMGYGA1UdIARfMF0wWwYLYIZIAYb4
'' SIG '' RQEHFwYwTDAjBggrBgEFBQcCARYXaHR0cHM6Ly9kLnN5
'' SIG '' bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIwGQwXaHR0cHM6
'' SIG '' Ly9kLnN5bWNiLmNvbS9ycGEwHQYDVR0OBBYEFPsxU7iZ
'' SIG '' MQ82sRMZZ9wcUZpCtgBaMFgGCCsGAQUFBwEBBEwwSjAf
'' SIG '' BggrBgEFBQcwAYYTaHR0cDovL3N3LnN5bWNkLmNvbTAn
'' SIG '' BggrBgEFBQcwAoYbaHR0cDovL3N3MS5zeW1jYi5jb20v
'' SIG '' c3cuY3J0MB8GA1UdIwQYMBaAFBZm3ko041CnEYYDsWyp
'' SIG '' xqzNWW6bMA0GCSqGSIb3DQEBCwUAA4IBAQBQEAjwXAas
'' SIG '' FygBRU/4fmAgJdTZDZFT/Gri5Vi28b6iHzDnTKcr3QTJ
'' SIG '' 33Ql9LbIi2CjtnD1n0zyvIdjXDXFLcbeMoQQ9L5XuiRw
'' SIG '' kwUPpRrLYsNPQ8G3n7N/me223Sw4noAy0ErrUNZd4Bew
'' SIG '' mTc3hn/95O1LC9QuGNFv/l+RyyFXBe3iJvHOpMBwIkMa
'' SIG '' OXB5/2FbFLqqELV4zWE2GXHhxfgxTgHHww1pJNBdPpxR
'' SIG '' qIjQxmgkL24azZZyxxtRWI6mpgCu+/4ZeXzwKSMycBYc
'' SIG '' gVG9c5TUSh+s1a4HPrrBJ1lPJQ+8+v3rc6ytjZXAC/g8
'' SIG '' GhhIrxvatjLMNWzrFNG7iEciMYIEhjCCBIICAQEwgaYw
'' SIG '' gZExCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
'' SIG '' YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMg
'' SIG '' VHJ1c3QgTmV0d29yazFCMEAGA1UEAxM5U3ltYW50ZWMg
'' SIG '' Q2xhc3MgMyBFeHRlbmRlZCBWYWxpZGF0aW9uIENvZGUg
'' SIG '' U2lnbmluZyBDQSAtIEcyAhAeObM6nEaakCI61S77g784
'' SIG '' MAkGBSsOAwIaBQCggaYwGQYJKoZIhvcNAQkDMQwGCisG
'' SIG '' AQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
'' SIG '' gjcCARUwIwYJKoZIhvcNAQkEMRYEFBc9ccZZ/2kLlrQM
'' SIG '' jphZon0n+OQVMEYGCisGAQQBgjcCAQwxODA2oDSAMgBB
'' SIG '' AGQAbwBiAGUAIABJAGwAbAB1AHMAdAByAGEAdABvAHIA
'' SIG '' IABDAEMAIAAyADAAMQA1MA0GCSqGSIb3DQEBAQUABIIB
'' SIG '' AI/0bXTQfly/uCjm54MmjGRpcf9jfr1ii0WZDJCSVI1e
'' SIG '' UzghiAFaRbnvlU8DajPxDZP8W6rTCR1tRBQPvjIc0+Nm
'' SIG '' 7mVVlrILTLqetjBVTOQfPhmdfob2a3wxmVaR/Sq671i0
'' SIG '' lfNfcmAMB9NIXGFhbdNSWEBnKVJ4iaOdh1iMqmIN/2YS
'' SIG '' Mo5vZ9sHamnaYT9ZHkP2hD9h9vaxImAmjOQQWBoAwfWg
'' SIG '' Q/EnaaW6dTiO/du7DrF/yh5i5/o2rXOhMfjaS78Hppue
'' SIG '' 3iQ8Ho6S+QCekyfNWL+yG4aHHlZ9YeZsFKvZPcRYOgTt
'' SIG '' reaZXP7g6CeWnnh8QdTnwZbIa2/awSdyDFKhggILMIIC
'' SIG '' BwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQswCQYD
'' SIG '' VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
'' SIG '' YXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUgU3Rh
'' SIG '' bXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+vzVu
'' SIG '' BNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkD
'' SIG '' MQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMTYw
'' SIG '' MTE0MjMxNjMyWjAjBgkqhkiG9w0BCQQxFgQUb9jHgLFQ
'' SIG '' 8VSXqahdaIUsMudhATwwDQYJKoZIhvcNAQEBBQAEggEA
'' SIG '' hfYbEq6lHgyAr+V2n1ju+Cc8mTDl/edRy6sss7eVYDT6
'' SIG '' Ms7NbZmfh5kS1mQWJPb3nbDtScpRko5NWjO0nrMpzjsX
'' SIG '' Sigrt0J3TInD2oQGVnHkTfys5YxPlIAw36TRfS9QtoMD
'' SIG '' v8YQumosNzD6165Arfh6pVmxhTSQyi0eXftDwf4QYviB
'' SIG '' W9ky/R68fHLRVM7lwQqUkfsg7gUYIujhqoN5Khvk/OW+
'' SIG '' A5uxnhXZGnDCnybt8LGiWj9JtQbwE/Qpm0N8OH9eHUV9
'' SIG '' 0sKya3hFhhs95AZ8zj/Irgy11dm/yiA9oCe6sieUV8Vi
'' SIG '' qGnvRjaVnVWiok9woF3PKgZee3ol1to+Sw==
'' SIG '' End signature block
